package easik.ui.tree.popup;

import java.awt.event.ActionEvent;
import java.util.ArrayList;

import javax.swing.AbstractAction;
import javax.swing.JOptionPane;
import javax.swing.tree.DefaultMutableTreeNode;

import easik.Easik;
import easik.sketch.constraint.Constraint;
import easik.sketch.constraint.ProductConstraint;
import easik.sketch.constraint.SumConstraint;
import easik.sketch.path.SketchPath;

/**
 * Show constraint menu action for the information tree.
 * 
 * @author Kevin Green 2006
 * @since 2006-08-17 Kevin Green
 * @version 2006-08-22 Kevin Green
 */
public class DeletePathAction extends AbstractAction {	
	
	/**
	 *	Set up the remove path menu option.
	 */
	public DeletePathAction() {
		super("Remove Path from Constraint");
		putValue( AbstractAction.SHORT_DESCRIPTION,  "Removes the currently selected path from the constraint.");		
	}
	
	/**
	 * Tests if the removal is valid and then removes the path from the constraint
	 * 
	 * @param e The action event
	 */
	public void actionPerformed(ActionEvent e ) {
		//If there is nothing seleceted then just do nothing
		if(Easik.getInstance().getFrame().getInfoTreeUI().getInfoTree().isSelectionEmpty())
		{
			return;
		}
		
		//Get currently selected object
		DefaultMutableTreeNode curSelectedNode = (DefaultMutableTreeNode) 
					Easik.getInstance().getFrame().getInfoTreeUI().getInfoTree().getSelectionPath().getLastPathComponent();
		Object curSelected = curSelectedNode.getUserObject();
		
		//Selection is a constraint
		if(curSelected instanceof SketchPath){
			Constraint curConstraint = (Constraint) ((DefaultMutableTreeNode)curSelectedNode.getParent()).getUserObject();
			ArrayList<SketchPath> tempPaths = (ArrayList<SketchPath>) curConstraint.getPaths().clone();
			tempPaths.remove(curSelected);
			if(curConstraint instanceof SumConstraint){
				if(SumConstraint.isSumConstraint(tempPaths)){
					SumConstraint myConst = (SumConstraint)curConstraint;
					//Replace previous path array list
					myConst.setPaths(tempPaths);
					//Remove old tree node
					myConst.getNode().removeFromParent();
					Easik.getInstance().getFrame().getInfoTreeUI().addConstraint(myConst);
					//Referesh Tree
					Easik.getInstance().getFrame().getInfoTreeUI().refreshTree(myConst.getNode());
				}
				else{
					JOptionPane.showMessageDialog(Easik.getInstance().getFrame(),
							"Revoming this path would make the constraint invalid.\nPath was not removed",
							"Path Not Removed", JOptionPane.ERROR_MESSAGE);
				}
			}
			else if(curConstraint instanceof ProductConstraint){
				if(ProductConstraint.isProductConstraint(tempPaths)){
					ProductConstraint myConst = (ProductConstraint)curConstraint;
					//Replace previous path array list
					myConst.setPaths(tempPaths);
					//Remove old tree node
					myConst.getNode().removeFromParent();
					Easik.getInstance().getFrame().getInfoTreeUI().addConstraint(myConst);
					//Referesh Tree
					Easik.getInstance().getFrame().getInfoTreeUI().refreshTree(myConst.getNode());
				}
				else{
					JOptionPane.showMessageDialog(Easik.getInstance().getFrame(),
							"Revoming this path would make the constraint invalid.\nPath was not removed",
							"Path Not Removed", JOptionPane.ERROR_MESSAGE);
				}
			}
			else{
				JOptionPane.showMessageDialog(Easik.getInstance().getFrame(),
						"You don't have a path selected that can be removed. \nPlease select another path and try again.",
						"No Constraint Selected", JOptionPane.ERROR_MESSAGE);
			}
		}
		//Selection is not a constraint
		else{ 
			JOptionPane.showMessageDialog(Easik.getInstance().getFrame(),
					"You don't have a path selected. \nPlease select a path and try again.",
					"No Constraint Selected", JOptionPane.ERROR_MESSAGE);
		}
	}
}